/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * frmKhachHang.java
 *
 * Created on May 12, 2011, 1:40:28 PM
 */

package Presentation;

import RSCall.DuongRSc;
import RSCall.KhachHangRSc;
import RSCall.PhuongRSc;
import RSCall.QuanRSc;
import RSCall.ThanhPhoRSc;
import Entities.DUONG;
import Entities.KHACHHANG;
import Entities.PHUONG;
import Entities.QUAN;
import Entities.THANHPHO;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
/**
 *
 * @author VooKa
 */
public class frmKhachHang extends javax.swing.JInternalFrame {

    /** Creates new form frmKhachHang */
    public frmKhachHang() {
        initComponents();
        Creation();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPopupMenu1 = new javax.swing.JPopupMenu();
        jPanel1 = new javax.swing.JPanel();
        btnTimKiem = new javax.swing.JButton();
        chbxMaKH = new javax.swing.JCheckBox();
        chbxEmail = new javax.swing.JCheckBox();
        chbxHoTen = new javax.swing.JCheckBox();
        btnDanhSach = new javax.swing.JButton();
        tbxMaKH_TraCuu = new javax.swing.JTextField();
        cbxThanhPhoTraCuu = new javax.swing.JComboBox();
        chbxThanhPho = new javax.swing.JCheckBox();
        chbxQuan = new javax.swing.JCheckBox();
        cbxQuanTraCuu = new javax.swing.JComboBox();
        cbxPhuongTraCuu = new javax.swing.JComboBox();
        chbxPhuong = new javax.swing.JCheckBox();
        chbxDuong = new javax.swing.JCheckBox();
        cbxDuongTraCuu = new javax.swing.JComboBox();
        tbxEmailTraCuu = new javax.swing.JTextField();
        tbxHoTenTraCuu = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        tbxHoTen = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        tbxDiaChiCT = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        tbxSoDT = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        tbxEmail = new javax.swing.JTextField();
        btnAdd = new javax.swing.JButton();
        btnUpdate = new javax.swing.JButton();
        btnDelete = new javax.swing.JButton();
        jLabel15 = new javax.swing.JLabel();
        cbxThanhPho = new javax.swing.JComboBox();
        jLabel16 = new javax.swing.JLabel();
        cbxQuan = new javax.swing.JComboBox();
        jLabel12 = new javax.swing.JLabel();
        cbxPhuong = new javax.swing.JComboBox();
        jLabel13 = new javax.swing.JLabel();
        cbxDuong = new javax.swing.JComboBox();
        jLabel14 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        tblKhachHang = new javax.swing.JTable();

        setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0), 1, true));
        setTitle(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("customer"));
        setName("frmKhachHang"); // NOI18N
        setPreferredSize(new java.awt.Dimension(999, 620));
        addInternalFrameListener(new javax.swing.event.InternalFrameListener() {
            public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameOpened(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("tracuuKH")));

        btnTimKiem.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("search"));
        btnTimKiem.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        btnTimKiem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnTimKiemActionPerformed(evt);
            }
        });

        chbxMaKH.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("customerid"));
        chbxMaKH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chbxMaKHActionPerformed(evt);
            }
        });

        chbxEmail.setText("Email");
        chbxEmail.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chbxEmailActionPerformed(evt);
            }
        });

        chbxHoTen.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("hoten"));
        chbxHoTen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chbxHoTenActionPerformed(evt);
            }
        });

        btnDanhSach.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("list"));
        btnDanhSach.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDanhSachActionPerformed(evt);
            }
        });

        tbxMaKH_TraCuu.setEnabled(false);

        cbxThanhPhoTraCuu.setEnabled(false);

        chbxThanhPho.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("city"));
        chbxThanhPho.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chbxThanhPhoActionPerformed(evt);
            }
        });

        chbxQuan.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("district"));
        chbxQuan.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chbxQuanActionPerformed(evt);
            }
        });

        cbxQuanTraCuu.setEnabled(false);

        cbxPhuongTraCuu.setEnabled(false);

        chbxPhuong.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("precinct"));
        chbxPhuong.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chbxPhuongActionPerformed(evt);
            }
        });

        chbxDuong.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("street"));
        chbxDuong.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chbxDuongActionPerformed(evt);
            }
        });

        cbxDuongTraCuu.setEnabled(false);

        tbxEmailTraCuu.setEnabled(false);

        tbxHoTenTraCuu.setEnabled(false);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup()
                        .addGap(28, 28, 28)
                        .addComponent(btnDanhSach, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(120, 120, 120)
                        .addComponent(btnTimKiem, javax.swing.GroupLayout.PREFERRED_SIZE, 91, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(chbxMaKH)
                            .addComponent(chbxThanhPho)
                            .addComponent(chbxQuan)
                            .addComponent(chbxPhuong)
                            .addComponent(chbxDuong)
                            .addComponent(chbxEmail)
                            .addComponent(chbxHoTen))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(tbxHoTenTraCuu)
                            .addComponent(tbxEmailTraCuu)
                            .addComponent(cbxDuongTraCuu, javax.swing.GroupLayout.Alignment.LEADING, 0, 201, Short.MAX_VALUE)
                            .addComponent(cbxQuanTraCuu, javax.swing.GroupLayout.Alignment.LEADING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(tbxMaKH_TraCuu, javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(cbxThanhPhoTraCuu, javax.swing.GroupLayout.Alignment.LEADING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(cbxPhuongTraCuu, javax.swing.GroupLayout.Alignment.LEADING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(9, 9, 9)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tbxMaKH_TraCuu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(chbxMaKH))
                .addGap(11, 11, 11)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(chbxThanhPho)
                    .addComponent(cbxThanhPhoTraCuu, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(11, 11, 11)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbxQuanTraCuu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(chbxQuan))
                .addGap(11, 11, 11)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbxPhuongTraCuu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(chbxPhuong))
                .addGap(11, 11, 11)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(chbxDuong)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(2, 2, 2)
                        .addComponent(cbxDuongTraCuu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(11, 11, 11)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(chbxEmail)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(2, 2, 2)
                        .addComponent(tbxEmailTraCuu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(11, 11, 11)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(chbxHoTen)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(2, 2, 2)
                        .addComponent(tbxHoTenTraCuu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(36, 36, 36)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnDanhSach, javax.swing.GroupLayout.PREFERRED_SIZE, 29, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnTimKiem, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(30, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("chudiaoc")));

        jLabel1.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("hoten"));

        jLabel2.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("address"));

        jLabel3.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("soDT"));

        jLabel4.setText("Email:");

        btnAdd.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("insert"));
        btnAdd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnAddActionPerformed(evt);
            }
        });

        btnUpdate.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("update"));
        btnUpdate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnUpdateActionPerformed(evt);
            }
        });

        btnDelete.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("delete"));
        btnDelete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDeleteActionPerformed(evt);
            }
        });

        jLabel15.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("city"));

        jLabel16.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("district"));

        jLabel12.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("precinct"));

        jLabel13.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("street"));

        cbxDuong.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Chọn Đường" }));

        jLabel14.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("detail"));

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel4)
                        .addGap(18, 18, 18)
                        .addComponent(tbxEmail, javax.swing.GroupLayout.DEFAULT_SIZE, 269, Short.MAX_VALUE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addGap(18, 18, 18)
                        .addComponent(tbxSoDT, javax.swing.GroupLayout.DEFAULT_SIZE, 231, Short.MAX_VALUE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addGap(18, 18, 18)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(tbxHoTen, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 231, Short.MAX_VALUE)
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel16)
                                    .addComponent(jLabel15)
                                    .addComponent(jLabel12)
                                    .addComponent(jLabel13)
                                    .addComponent(jLabel14))
                                .addGap(18, 18, 18)
                                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(tbxDiaChiCT, javax.swing.GroupLayout.DEFAULT_SIZE, 147, Short.MAX_VALUE)
                                    .addComponent(cbxDuong, 0, 147, Short.MAX_VALUE)
                                    .addComponent(cbxPhuong, javax.swing.GroupLayout.Alignment.TRAILING, 0, 147, Short.MAX_VALUE)
                                    .addComponent(cbxQuan, javax.swing.GroupLayout.Alignment.TRAILING, 0, 147, Short.MAX_VALUE)
                                    .addComponent(cbxThanhPho, javax.swing.GroupLayout.Alignment.TRAILING, 0, 147, Short.MAX_VALUE)))))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(btnAdd, javax.swing.GroupLayout.PREFERRED_SIZE, 71, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(36, 36, 36)
                        .addComponent(btnUpdate, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(36, 36, 36)
                        .addComponent(btnDelete, javax.swing.GroupLayout.PREFERRED_SIZE, 69, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(tbxHoTen, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel15)
                            .addComponent(cbxThanhPho, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel16)
                            .addComponent(cbxQuan, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel12)
                    .addComponent(cbxPhuong, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel13)
                    .addComponent(cbxDuong, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel14)
                    .addComponent(tbxDiaChiCT, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(tbxSoDT, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(tbxEmail, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, Short.MAX_VALUE)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnUpdate, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnDelete, javax.swing.GroupLayout.PREFERRED_SIZE, 29, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnAdd, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(69, 69, 69))
        );

        tblKhachHang.setFont(new java.awt.Font("Arial", 0, 12)); // NOI18N
        tblKhachHang.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        tblKhachHang.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                tblKhachHangMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(tblKhachHang);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 977, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, 356, Short.MAX_VALUE))
                .addGap(16, 16, 16)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 162, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(48, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formInternalFrameOpened(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameOpened
        try {
            LoadData(dbKhachHang.mainList);
        } catch (Exception ex) {
            Logger.getLogger(frmKhachHang.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_formInternalFrameOpened

    // Xử lý thêm một khách hàng
    private void btnAddActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnAddActionPerformed
        String hoTen = tbxHoTen.getText().trim();
        String maThanhPho = ((THANHPHO)cbxThanhPho.getSelectedItem()).getMaThanhPho();
        String maQuan = ((QUAN)cbxQuan.getSelectedItem()).getMaQuan();
        String maPhuong = ((PHUONG)cbxPhuong.getSelectedItem()).getMaPhuong();
        String maDuong = "DG000";
        if (cbxDuong.getSelectedIndex() != 0) {
            maDuong = ((DUONG)cbxDuong.getSelectedItem()).getMaDuong();
        }
        String diaChiCT = tbxDiaChiCT.getText().trim();
        String soDT = tbxSoDT.getText().trim();
        String email = tbxEmail.getText().trim();
        Utilities.Utilities.EmailValidator em = new Utilities.Utilities.EmailValidator();
        if(hoTen.isEmpty()){
            JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustenterhoten"));
        }else if(soDT.isEmpty()){
            JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustentersodt"));
        }else if(email.isEmpty()){
            JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustenteremail"));
        }else if(!em.validate(email)) {
            JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustentervalidemail"));
        }else{
            try
            {
                dbKhachHang.Insert(hoTen, maThanhPho, maQuan, maPhuong, maDuong, diaChiCT, soDT, email);
                this.LoadData(dbKhachHang.GetAllRows());
                tbxHoTen.setText("");
                tbxDiaChiCT.setText("");
                tbxSoDT.setText("");
                tbxEmail.setText("");
                JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("insertedacustomer"));
            }catch(Exception e){
                JOptionPane.showMessageDialog(this, e.toString());
            }
        }
    }//GEN-LAST:event_btnAddActionPerformed

    // Xử lý chọn Khách hàng
    private void tblKhachHangMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_tblKhachHangMouseClicked
        int index = this.tblKhachHang.getSelectedRow();
        String maKH = this.tblKhachHang.getValueAt(index, 1).toString();
        KHACHHANG khachHang = new KHACHHANG();
        try{
            khachHang = dbKhachHang.GetRowByID(maKH);
            tbxHoTen.setText(khachHang.getHoTen().trim());
            cbxThanhPho.setSelectedIndex(listThanhPho.indexOf(khachHang.getDiaChiKH().getMaThanhPho()));
            cbxQuan.setSelectedIndex(listQuan.indexOf(khachHang.getDiaChiKH().getMaQuan()));
            cbxPhuong.setSelectedIndex(listPhuong.indexOf(khachHang.getDiaChiKH().getMaPhuong())) ;
            cbxDuong.setSelectedIndex(listDuong.indexOf(khachHang.getDiaChiKH().getMaDuong())+1);
            tbxDiaChiCT.setText(khachHang.getDiaChiKH().getDiaChiCT().trim());
            tbxSoDT.setText(khachHang.getSoDT().trim());
            tbxEmail.setText(khachHang.getEmail().trim());
            
        }catch(Exception ev){
            JOptionPane.showMessageDialog(rootPane, ev.toString());
        }
    }//GEN-LAST:event_tblKhachHangMouseClicked

    // Xử lý Cập nhật Khách hàng
    private void btnUpdateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnUpdateActionPerformed
        // TODO add your handling code here:
        String maKH = (String)tblKhachHang.getValueAt(tblKhachHang.getSelectedRow(), 1);
        String hoTen = tbxHoTen.getText().trim();
        String maThanhPho = ((THANHPHO)cbxThanhPho.getSelectedItem()).getMaThanhPho();
        String maQuan = ((QUAN)cbxQuan.getSelectedItem()).getMaQuan();
        String maPhuong = ((PHUONG)cbxPhuong.getSelectedItem()).getMaPhuong();
        String maDuong = "DG000";
        if (cbxDuong.getSelectedIndex() != 0) {
            maDuong = ((DUONG)cbxDuong.getSelectedItem()).getMaDuong();
        }
        String diaChiCT = tbxDiaChiCT.getText().trim();
        String soDT = tbxSoDT.getText().trim();
        String email = tbxEmail.getText().trim();
        Utilities.Utilities.EmailValidator em = new Utilities.Utilities.EmailValidator();
        if(tblKhachHang.getSelectedRow()==-1)
            JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustselectGiaTien"));
        else if(hoTen.isEmpty()){
            JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustenterhoten"));
        }else if(soDT.isEmpty()){
            JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustentersodt"));
        }else if(email.isEmpty()){
            JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustenteremail"));
        }else if(!em.validate(email)) {
            JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustentervalidemail"));
        }else{
            try
            {
                dbKhachHang.Update(maKH, hoTen, maThanhPho, maQuan, maPhuong, maDuong, diaChiCT, soDT, email);
                this.LoadData(dbKhachHang.GetAllRows());
                tbxHoTen.setText("");
                tbxDiaChiCT.setText("");
                tbxSoDT.setText("");
                tbxEmail.setText("");
                JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("updatedacustomer"));
            }catch(Exception e){
                JOptionPane.showMessageDialog(this, e.toString());
            }
        }
    }//GEN-LAST:event_btnUpdateActionPerformed

    // Xử lý xóa một Khách hàng
    private void btnDeleteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDeleteActionPerformed
        // TODO add your handling code here:
        if(tblKhachHang.getSelectedRow()==-1){
            JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustselectGiaTien"));
        }
        else{
            int i = JOptionPane.showConfirmDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("really delete"), java.util.ResourceBundle.getBundle("Presentation/vn").getString("warn"), JOptionPane.YES_NO_OPTION);
            if(i == 0)
            {
                try
                {
                    String maKH = tblKhachHang.getValueAt(tblKhachHang.getSelectedRow(), 1).toString();
                    dbKhachHang.Delete(maKH);
                    this.LoadData(dbKhachHang.GetAllRows());
                    tbxHoTen.setText("");
                    tbxDiaChiCT.setText("");
                    tbxSoDT.setText("");
                    tbxEmail.setText("");
                    JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("deletedacustomer") + maKH);
                }catch(Exception e){
                    JOptionPane.showMessageDialog(this, e.toString());
                }
            }
        }
    }//GEN-LAST:event_btnDeleteActionPerformed

    // Xử lý tìm kiếm Khách hàng
    private void btnTimKiemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnTimKiemActionPerformed
        try {
            ArrayList<KHACHHANG> rs = new ArrayList<KHACHHANG>();                           // List KHACHHANG kết quả tìm kiếm
            ArrayList<KHACHHANG> rsTemp = new ArrayList<KHACHHANG>();
            rs = dbKhachHang.GetAllRows();
            
            if(chbxMaKH.isSelected()){                                               // Tìm kiếm theo Mã Khách hàng
                rsTemp = (ArrayList<KHACHHANG>)rs.clone();
                rs.clear();
                if (tbxMaKH_TraCuu.getText().trim().isEmpty()) {
                    JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustentercustomerid"));
                }else if(tbxMaKH_TraCuu.getText().trim().length() != 5){
                    JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("validcustomerid"));
                }else{
                    for(KHACHHANG d : rsTemp){
                        if (d.getMaKH().equalsIgnoreCase(tbxMaKH_TraCuu.getText().trim())) {
                            rs.add(d);
                            break;
                        }
                    }
                }
                this.LoadData(rs);
                return;
            }
            
            if (chbxEmail.isSelected()) {
                rsTemp = (ArrayList<KHACHHANG>)rs.clone();
                rs.clear();
                String email = tbxEmailTraCuu.getText().trim().toLowerCase();
                if (email.isEmpty()) {
                    JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustenteremail"));
                }else{
                    for(KHACHHANG d : rsTemp){
                        if (d.getEmail().toLowerCase().indexOf(email) != -1) {
                            rs.add(d);
                        }
                    }
                }
                this.LoadData(rs);
                return;
            }
            
            if(chbxThanhPho.isSelected()){                      // Tìm kiếm theo Thành phố
                rsTemp = (ArrayList<KHACHHANG>)rs.clone();
                rs.clear();
                
                String maThanhPho = ((THANHPHO)cbxThanhPhoTraCuu.getSelectedItem()).getMaThanhPho();
                for(KHACHHANG d : rsTemp){
                    if (d.getDiaChiKH().getMaThanhPho().equals(maThanhPho)) {
                        rs.add(d);
                    }
                }
                
            }
            
            if (chbxQuan.isSelected()) {                        // Tìm kiếm theo Quận
                rsTemp = (ArrayList<KHACHHANG>)rs.clone();
                rs.clear();
                String maQuan = ((QUAN)cbxQuanTraCuu.getSelectedItem()).getMaQuan();
                for(KHACHHANG d : rsTemp){
                    if (d.getDiaChiKH().getMaQuan().equals(maQuan)) {
                        rs.add(d);
                    }
                }
            }
            
            if (chbxPhuong.isSelected()) {                        // Tìm kiếm theo Phường
                rsTemp = (ArrayList<KHACHHANG>)rs.clone();
                rs.clear();
                String maPhuong = ((PHUONG)cbxPhuongTraCuu.getSelectedItem()).getMaPhuong();
                for(KHACHHANG d : rsTemp){
                    if (d.getDiaChiKH().getMaPhuong().equals(maPhuong)) {
                        rs.add(d);
                    }
                }
            }
            
            if (chbxDuong.isSelected()) {                       // Tìm kiếm theo Đường                
                rsTemp = (ArrayList<KHACHHANG>)rs.clone();
                rs.clear();
                String maDuong = ((DUONG)cbxDuongTraCuu.getSelectedItem()).getMaDuong();
                for(KHACHHANG d : rsTemp){
                    if(d.getDiaChiKH().getMaDuong().equals(maDuong)){
                        rs.add(d);
                    }
                }
            }
            
            if (chbxHoTen.isSelected()) {                   // Tìm kiếm theo Loại địa ốc
                rsTemp = (ArrayList<KHACHHANG>)rs.clone();
                rs.clear();
                Utilities.Utilities.StringUtil removeVietNam = new Utilities.Utilities.StringUtil();
                String hoTen = removeVietNam.RemoveSign4VietNameseString(tbxHoTenTraCuu.getText().trim().toLowerCase());
                if (hoTen.isEmpty()) {
                    JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("mustenterhoten"));
                }
                for(KHACHHANG d : rsTemp){
                    String hoTenKH = removeVietNam.RemoveSign4VietNameseString(d.getHoTen().trim());
                    if(hoTenKH.toLowerCase().indexOf(hoTen) != -1){
                        rs.add(d);
                    }
                }
            }
            
            this.LoadData(rs);
        } catch (Exception ex) {
            Logger.getLogger(frmDiaOc.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_btnTimKiemActionPerformed

    // Xử lý chọn mục tìm kiếm
    private void chbxMaKHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chbxMaKHActionPerformed
        tbxMaKH_TraCuu.setEnabled(chbxMaKH.isSelected());
        chbxThanhPho.setEnabled(!chbxMaKH.isSelected());
        chbxQuan.setEnabled(!chbxMaKH.isSelected());
        chbxPhuong.setEnabled(!chbxMaKH.isSelected());
        chbxDuong.setEnabled(!chbxMaKH.isSelected());
        chbxHoTen.setEnabled(!chbxMaKH.isSelected());
        chbxEmail.setEnabled(!chbxMaKH.isSelected());
    }//GEN-LAST:event_chbxMaKHActionPerformed

    private void chbxEmailActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chbxEmailActionPerformed
        tbxEmailTraCuu.setEnabled(chbxEmail.isSelected());
        chbxThanhPho.setEnabled(!chbxEmail.isSelected());
        chbxQuan.setEnabled(!chbxEmail.isSelected());
        chbxPhuong.setEnabled(!chbxEmail.isSelected());
        chbxDuong.setEnabled(!chbxEmail.isSelected());
        chbxHoTen.setEnabled(!chbxEmail.isSelected());
        chbxMaKH.setEnabled(!chbxEmail.isSelected());
    }//GEN-LAST:event_chbxEmailActionPerformed

    private void chbxHoTenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chbxHoTenActionPerformed
        tbxHoTenTraCuu.setEnabled(chbxHoTen.isSelected());
    }//GEN-LAST:event_chbxHoTenActionPerformed

    // Hiện danh sách
    private void btnDanhSachActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDanhSachActionPerformed
        try{
            this.LoadData(dbKhachHang.GetAllRows());
        }catch(Exception e){
            JOptionPane.showMessageDialog(this, e.toString());
        }
    }//GEN-LAST:event_btnDanhSachActionPerformed

    private void chbxThanhPhoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chbxThanhPhoActionPerformed
        cbxThanhPhoTraCuu.setEnabled(chbxThanhPho.isSelected());
}//GEN-LAST:event_chbxThanhPhoActionPerformed

    private void chbxQuanActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chbxQuanActionPerformed
        cbxQuanTraCuu.setEnabled(chbxQuan.isSelected());
}//GEN-LAST:event_chbxQuanActionPerformed

    private void chbxPhuongActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chbxPhuongActionPerformed
        cbxPhuongTraCuu.setEnabled(chbxPhuong.isSelected());
}//GEN-LAST:event_chbxPhuongActionPerformed

    private void chbxDuongActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chbxDuongActionPerformed
        cbxDuongTraCuu.setEnabled(chbxDuong.isSelected());
}//GEN-LAST:event_chbxDuongActionPerformed

    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAdd;
    private javax.swing.JButton btnDanhSach;
    private javax.swing.JButton btnDelete;
    private javax.swing.JButton btnTimKiem;
    private javax.swing.JButton btnUpdate;
    private javax.swing.JComboBox cbxDuong;
    private javax.swing.JComboBox cbxDuongTraCuu;
    private javax.swing.JComboBox cbxPhuong;
    private javax.swing.JComboBox cbxPhuongTraCuu;
    private javax.swing.JComboBox cbxQuan;
    private javax.swing.JComboBox cbxQuanTraCuu;
    private javax.swing.JComboBox cbxThanhPho;
    private javax.swing.JComboBox cbxThanhPhoTraCuu;
    private javax.swing.JCheckBox chbxDuong;
    private javax.swing.JCheckBox chbxEmail;
    private javax.swing.JCheckBox chbxHoTen;
    private javax.swing.JCheckBox chbxMaKH;
    private javax.swing.JCheckBox chbxPhuong;
    private javax.swing.JCheckBox chbxQuan;
    private javax.swing.JCheckBox chbxThanhPho;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPopupMenu jPopupMenu1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable tblKhachHang;
    private javax.swing.JTextField tbxDiaChiCT;
    private javax.swing.JTextField tbxEmail;
    private javax.swing.JTextField tbxEmailTraCuu;
    private javax.swing.JTextField tbxHoTen;
    private javax.swing.JTextField tbxHoTenTraCuu;
    private javax.swing.JTextField tbxMaKH_TraCuu;
    private javax.swing.JTextField tbxSoDT;
    // End of variables declaration//GEN-END:variables

    private RSCall.KhachHangRSc dbKhachHang;
    private RSCall.ThanhPhoRSc dbThanhPho;
    private RSCall.QuanRSc dbQuan;
    private RSCall.PhuongRSc dbPhuong;
    private RSCall.DuongRSc dbDuong;
    
    private ArrayList<String> listThanhPho;
    private ArrayList<String> listQuan;
    private ArrayList<String> listPhuong;
    private ArrayList<String> listDuong;
    
    private void Creation(){
        try {
            dbKhachHang = new KhachHangRSc();
            dbThanhPho = new ThanhPhoRSc();
            dbQuan = new QuanRSc();
            dbPhuong = new PhuongRSc();
            dbDuong = new DuongRSc();    
            listThanhPho = new ArrayList<String> ();
            listQuan = new ArrayList<String> ();
            listPhuong = new ArrayList<String> ();
            listDuong = new ArrayList<String> ();
            
            // Tạo dữ liệu cho Thành phố
            for(THANHPHO t : dbThanhPho.mainList){
                cbxThanhPho.addItem(t);
                cbxThanhPhoTraCuu.addItem(t);
                listThanhPho.add(t.getMaThanhPho());
            }
            
            // Tạo dữ liệu cho Quận
            for(QUAN q : dbQuan.mainList){
                cbxQuan.addItem(q);
                cbxQuanTraCuu.addItem(q);
                listQuan.add(q.getMaQuan());
            }
            
            // Tạo dữ liệu cho Phường
            for(PHUONG p : dbPhuong.mainList){
                cbxPhuong.addItem(p);
                cbxPhuongTraCuu.addItem(p);
                listPhuong.add(p.getMaPhuong());
            }
            
            // Tạo dữ liệu cho Đường
            for(DUONG d : dbDuong.mainList){
                cbxDuong.addItem(d);
                cbxDuongTraCuu.addItem(d);
                listDuong.add(d.getMaDuong());
            }
            
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(rootPane, ex.toString());
            Logger.getLogger(frmKhachHang.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    // Load dữ liệu
    private void LoadData(ArrayList<KHACHHANG> lst)throws Exception{
        DefaultTableModel dtm = new DefaultTableModel(){
            @Override
            public boolean isCellEditable(int x,int y){
                if(y>=0&&y<=4)
                    return false;
                return true;
            }
        };
        dtm.addColumn("STT");
        dtm.addColumn("Mã");
        dtm.addColumn(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("hoten"));
        dtm.addColumn(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("address"));
        dtm.addColumn(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("soDT"));
        dtm.addColumn("Email");
        for(int i=0;i<lst.size();i++)
        {
            KHACHHANG khachHang = lst.get(i);
            Vector _v = new Vector();
            _v.add(i+1);
            _v.add(khachHang.getMaKH());
            _v.add(khachHang.getHoTen().trim());
            
            String tenThanhPho = dbThanhPho.GetRowByID(khachHang.getDiaChiKH().getMaThanhPho()).getTenThanhPho().trim();
            String tenQuan = dbQuan.GetRowByID(khachHang.getDiaChiKH().getMaQuan()).getTenQuan().trim();
            String tenPhuong = dbPhuong.GetRowByID(khachHang.getDiaChiKH().getMaPhuong()).getTenPhuong().trim();
            String tenDuong = dbDuong.GetRowByID(khachHang.getDiaChiKH().getMaDuong()).getTenDuong().trim();
            String diaChiCT = khachHang.getDiaChiKH().getDiaChiCT().trim();
            String diaChi = diaChiCT + " " + tenDuong + " " + tenPhuong + " " + tenQuan + " " + tenThanhPho;
            _v.add(diaChi);
            _v.add(khachHang.getSoDT().trim());
            _v.add(khachHang.getEmail().trim());
            dtm.addRow(_v);
        }
        this.tblKhachHang.setModel(dtm);
        
        this.tblKhachHang.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.tblKhachHang.getColumnModel().getColumn(1).setPreferredWidth(15);
        this.tblKhachHang.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.tblKhachHang.getColumnModel().getColumn(3).setPreferredWidth(220);
        this.tblKhachHang.getColumnModel().getColumn(4).setPreferredWidth(20);        
        this.tblKhachHang.getColumnModel().getColumn(5).setPreferredWidth(20);
    }
    
    
}